/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.log;

import com.ibm.hwmca.fw.log.ClassLogInfo;
import com.ibm.hwmca.fw.log.DumpAttributes;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogAttributes;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.dump.JVMDump;
import java.io.PrintWriter;
import java.io.StringWriter;

public class MicrocodeLog
extends Log {
    private static final boolean MYDEBUG = false;
    private static final String TRACE_MASKT = "XFRMMLCT";
    private static final String TRACE_MASKF = "XFRMMLCF";
    private static final String TRACE_MASKD = "XFRMMLCD";
    private short errorId_;
    private int errorReason_;
    static /* synthetic */ Class class$com$ibm$hwmca$fw$log$MicrocodeLog;

    public MicrocodeLog(ClassLogInfo classLogInfo, short user, short errorId, int errorReason, Throwable thrown, String logId, String towerData) {
        super(classLogInfo.getLogClass(), classLogInfo.getLogType(), user, classLogInfo.getEventName(), null, thrown, logId, towerData);
        if (this.getClass().getName().equals((class$com$ibm$hwmca$fw$log$MicrocodeLog == null ? (class$com$ibm$hwmca$fw$log$MicrocodeLog = MicrocodeLog.class$("com.ibm.hwmca.fw.log.MicrocodeLog")) : class$com$ibm$hwmca$fw$log$MicrocodeLog).getName())) {
            Trace.trace(TRACE_MASKT, "-> MicrocodeLog(classLogInfo=" + classLogInfo + ",user=0x" + HexString.toHex(user, true) + ",errorId=0x" + HexString.toHex(errorId, true) + ",errorReason=0x" + HexString.toHex(errorReason, true));
            Trace.trace(TRACE_MASKT, ",thrown=" + thrown + ",logId=" + logId + ",towerData=" + towerData + ")");
        }
        if (errorReason == 0) {
            Throwable hashThrown = thrown;
            if (hashThrown == null) {
                hashThrown = new Exception();
            }
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            hashThrown.printStackTrace(printWriter);
            errorReason = stringWriter.toString().hashCode();
        }
        this.setErrorId(errorId);
        this.setErrorReason(errorReason);
    }

    public void setClassLogInfo(ClassLogInfo classLogInfo) {
        this.setLogClass(classLogInfo.getLogClass());
        this.setLogType(classLogInfo.getLogType());
        this.setEventName(classLogInfo.getEventName());
    }

    public ClassLogInfo getClassLogInfo() {
        return new ClassLogInfo(this.getLogClass(), this.getLogType(), this.getEventName());
    }

    public void setErrorId(short errorId) {
        this.errorId_ = errorId;
    }

    public short getErrorId() {
        return this.errorId_;
    }

    public void setErrorReason(int errorReason) {
        this.errorReason_ = errorReason;
    }

    public int getErrorReason() {
        return this.errorReason_;
    }

    public LogEntryId log(LogAttributes attribs) {
        if (this.getClass().getName().equals((class$com$ibm$hwmca$fw$log$MicrocodeLog == null ? (class$com$ibm$hwmca$fw$log$MicrocodeLog = MicrocodeLog.class$("com.ibm.hwmca.fw.log.MicrocodeLog")) : class$com$ibm$hwmca$fw$log$MicrocodeLog).getName())) {
            Trace.trace(TRACE_MASKT, "-> log(attribs=" + attribs + ")");
        }
        LogEntryId result = super.log(attribs);
        if (attribs instanceof DumpAttributes && ((DumpAttributes)((Object)attribs)).isJvmDump()) {
            try {
                String jdiPort = System.getProperty("JDI_PORT");
                if (jdiPort != null) {
                    Trace.trace(TRACE_MASKF, "Dumping the JVM at port " + jdiPort);
                    String towerData = this.getTowerData();
                    JVMDump.dump(null, Integer.decode(jdiPort), this.getTowerData());
                } else {
                    Trace.trace(TRACE_MASKF, "Skipping dumping the JVM.  No connector available." + jdiPort);
                }
            }
            catch (Exception exc) {
                Trace.trace(TRACE_MASKF, exc);
            }
        }
        if (this.getClass().getName().equals((class$com$ibm$hwmca$fw$log$MicrocodeLog == null ? (class$com$ibm$hwmca$fw$log$MicrocodeLog = MicrocodeLog.class$("com.ibm.hwmca.fw.log.MicrocodeLog")) : class$com$ibm$hwmca$fw$log$MicrocodeLog).getName())) {
            Trace.trace(TRACE_MASKT, "<- log()");
        }
        return result;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName()).append("@").append(this.hashCode()).append("[0x").append(HexString.toHex(this.getLogClass(), true)).append(",0x").append(HexString.toHex(this.getLogType(), true)).append(",0x").append(HexString.toHex(this.getUser(), true)).append(",0x").append(HexString.toHex(this.getErrorId(), true)).append(",0x").append(HexString.toHex(this.getErrorReason(), true)).append(",").append(this.getTimestamp()).append(",").append(this.getLogId()).append("]");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

